-- Criar o banco de dados
CREATE DATABASE Autopag;
USE Autopag;

-- Criar tabela de Usuários
CREATE TABLE Usuarios (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nome VARCHAR(100) NOT NULL,
    email VARCHAR(255) UNIQUE NOT NULL,
    senha VARCHAR(128) NOT NULL,
    data_criacao DATETIME DEFAULT CURRENT_TIMESTAMP,
    data_atualizacao DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Criar tabela de Contas Correntes
CREATE TABLE ContaCorrente (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nome_empresa VARCHAR(255) NOT NULL,
    numero_conta VARCHAR(29) NOT NULL,
    data_criacao DATETIME DEFAULT CURRENT_TIMESTAMP,
    data_atualizacao DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Criar tabela de Pagamentos
CREATE TABLE Pagamentos (
    id INT AUTO_INCREMENT PRIMARY KEY,
    destinatario VARCHAR(255) NOT NULL,
    valor DECIMAL(10,2) NOT NULL,
    chave_pix VARCHAR(255) NOT NULL,
    conta_corrente_id INT,
    data_pagamento DATETIME DEFAULT CURRENT_TIMESTAMP,
    status_pagamento VARCHAR(255) NOT NULL,
    data_criacao DATETIME DEFAULT CURRENT_TIMESTAMP,
    data_atualizacao DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (conta_corrente_id) REFERENCES ContaCorrente(id) ON DELETE CASCADE
);

-- Criar tabela de Retorno de Pagamentos
CREATE TABLE RetornoPagamentos (
    id INT AUTO_INCREMENT PRIMARY KEY,
    id_pagamento INT NOT NULL,
    codigo_solicitacao VARCHAR(255) NOT NULL,
    tipo_retorno VARCHAR(255) NOT NULL,
    conta_corrente VARCHAR(29) NOT NULL,
    recebedor JSON NOT NULL,
    erros JSON NOT NULL,
    endtoend VARCHAR(255) NOT NULL,
    valor_retorno DECIMAL(10,2) NOT NULL,
    status_retorno VARCHAR(255) NOT NULL,
    dataHoraMovimento DATETIME NOT NULL,
    dataHoraSolicitacao DATETIME NOT NULL,
    chave VARCHAR(255) NOT NULL,
    data_criacao DATETIME DEFAULT CURRENT_TIMESTAMP,
    data_atualizacao DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (id_pagamento) REFERENCES Pagamentos(id) ON DELETE CASCADE
);

-- Criar tabela de Histórico de Operações
CREATE TABLE HistoricoOperacoes (
    id INT AUTO_INCREMENT PRIMARY KEY,
    id_pagamento INT NOT NULL,
    id_retorno_pagamento INT NOT NULL,
    status VARCHAR(255) NOT NULL,
    dataHoraEvento DATETIME NOT NULL,
    data_criacao DATETIME DEFAULT CURRENT_TIMESTAMP,
    data_atualizacao DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (id_pagamento) REFERENCES Pagamentos(id) ON DELETE CASCADE,
    FOREIGN KEY (id_retorno_pagamento) REFERENCES RetornoPagamentos(id) ON DELETE CASCADE
);

-- Criar tabela de Logs de Status de Pagamentos
CREATE TABLE log_status_pagamentos (
    id INT AUTO_INCREMENT PRIMARY KEY,
    id_usuario INT NOT NULL,
    id_pagamento INT NOT NULL,
    status_anterior VARCHAR(255) NOT NULL,
    status_novo VARCHAR(255) NOT NULL,
    data_criacao DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (id_usuario) REFERENCES Usuarios(id) ON DELETE CASCADE,
    FOREIGN KEY (id_pagamento) REFERENCES Pagamentos(id) ON DELETE CASCADE
);

-- Criar tabela de Logs de Alterações
CREATE TABLE log_alteracoes (
    id INT AUTO_INCREMENT PRIMARY KEY,
    id_usuario INT NOT NULL,
    id_pagamento INT NOT NULL,
    campo_alterado VARCHAR(255) NOT NULL,
    valor_anterior VARCHAR(255) NOT NULL,
    valor_novo VARCHAR(255) NOT NULL,
    data_criacao DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (id_usuario) REFERENCES Usuarios(id) ON DELETE CASCADE,
    FOREIGN KEY (id_pagamento) REFERENCES Pagamentos(id) ON DELETE CASCADE
);
